package fr.asip.cps3.exemple.modele.resultats;

/**
 * Classe reprsentant le rsultat de gnration d'empreinte d'un fichier
 */
public class ResultatEmpreinteFichier extends ResultatTriple {

	/**
	 * L'empreinte
	 */
	private String empreinte;

	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param operation3 Description de la troisime opration
	 */
	public ResultatEmpreinteFichier(String operation1, String operation2, String operation3){
		this(operation1, operation2, operation3, "");
	}
	
	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param operation3 Description de la troisime opration
	 * @param empreinte L'empreinte
	 */
	public ResultatEmpreinteFichier(String operation1, String operation2, String operation3, String empreinte){
		super(operation1, operation2, operation3);
		this.empreinte = empreinte;
	}
	
	/**
	 * Accesseur
	 * @return L'empreinte
	 */
	public String getEmpreinte() {
		return this.empreinte;
	}

	/**
	 * Mutateur
	 * @param empreinte L'empreinte
	 */
	public void setEmpreinte(String empreinte) {
		this.empreinte = empreinte;
	}

}
